/*
 * Decompiled with CFR 0.152.
 */
package com.ncpbails.culturaldelights.block.entity.custom;

import com.ncpbails.culturaldelights.block.entity.ModBlockEntities;
import com.ncpbails.culturaldelights.recipe.BambooMatRecipe;
import com.ncpbails.culturaldelights.screen.BambooMatMenu;
import com.ncpbails.culturaldelights.util.ModTags;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooMatBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            BambooMatBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return BambooMatBlockEntity.this.progress;
                }
                case 1: {
                    return BambooMatBlockEntity.this.maxProgress;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    BambooMatBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    BambooMatBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public BambooMatBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.BAMBOO_MAT_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
    }

    public Component m_5446_() {
        return new TextComponent("Bamboo Mat");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new BambooMatMenu(pContainerId, pInventory, this, this.data);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("bamboo_mat.progress", this.progress);
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("bamboo_mat.progress");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, BambooMatBlockEntity pBlockEntity) {
        if (BambooMatBlockEntity.hasRecipe(pBlockEntity)) {
            ++pBlockEntity.progress;
            BambooMatBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            BambooMatBlockEntity.craftItem(pBlockEntity);
        } else {
            pBlockEntity.resetProgress();
            BambooMatBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private static boolean hasRecipe(BambooMatBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)BambooMatRecipe.Type.INSTANCE, (Container)inventory, level);
        return match.isPresent() && BambooMatBlockEntity.canInsertAmountIntoOutputSlot(inventory) && BambooMatBlockEntity.canInsertItemIntoOutputSlot(inventory, ((BambooMatRecipe)match.get()).m_8043_());
    }

    private static void craftItem(BambooMatBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        Optional match = level.m_7465_().m_44015_((RecipeType)BambooMatRecipe.Type.INSTANCE, (Container)inventory, level);
        if (match.isPresent()) {
            BambooMatBlockEntity.giveBowls(entity);
            entity.itemHandler.extractItem(0, 1, false);
            entity.itemHandler.extractItem(1, 1, false);
            entity.itemHandler.extractItem(2, 1, false);
            entity.itemHandler.extractItem(3, 1, false);
            entity.itemHandler.extractItem(4, 1, false);
            entity.itemHandler.setStackInSlot(5, new ItemStack((ItemLike)((BambooMatRecipe)match.get()).m_8043_().m_41720_(), entity.itemHandler.getStackInSlot(5).m_41613_() + 1));
            entity.resetProgress();
        }
    }

    private static void giveBowls(BambooMatBlockEntity entity) {
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        Optional match = entity.f_58857_.m_7465_().m_44015_((RecipeType)BambooMatRecipe.Type.INSTANCE, (Container)inventory, entity.f_58857_);
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            if (!entity.itemHandler.getStackInSlot(i).m_204117_(ModTags.Items.BOWL_FOODS) || entity.f_58857_.m_5776_()) continue;
            ItemEntity entityToSpawn = new ItemEntity(entity.f_58857_, (double)entity.f_58858_.m_123341_(), (double)entity.f_58858_.m_123342_(), (double)entity.f_58858_.m_123343_(), new ItemStack((ItemLike)Items.f_42399_));
            entity.f_58857_.m_7967_((Entity)entityToSpawn);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack output) {
        return inventory.m_8020_(5).m_41619_();
    }

    private static boolean canInsertAmountIntoOutputSlot(SimpleContainer inventory) {
        return inventory.m_8020_(5).m_41741_() > inventory.m_8020_(5).m_41613_();
    }
}

